// Launcher.js
// Version: 0.0.1
// Event: On Awake
// Description: Launch instantiated prefab

//@input Asset.ObjectPrefab prefab
/** @type {ObjectPrefab} */
var prefab = script.prefab;

//@input SceneObject launchFromObj
/** @type {SceneObject} */
var launchFromObj = script.launchFromObj;

//@input float timer
/** @type {number} */
var timer = script.timer;

//@input vec3 force
/** @type {vec3} */
var force = script.force;

var event = script.createEvent("DelayedCallbackEvent");
event.bind(function(eventData){
    var newObject = prefab.instantiate(null);
    var launchPos = launchFromObj.getTransform().getWorldPosition().add(launchFromObj.getTransform().forward.uniformScale(-100));
    newObject.getTransform().setWorldPosition(launchPos);
    var physicsBody = newObject.getComponent("Physics.BodyComponent");
    var forceDir = launchFromObj.getTransform().getWorldTransform().multiplyDirection(force);
    physicsBody.addForce(forceDir, Physics.ForceMode.Impulse);

    event.reset(timer);    
});
event.reset(timer);
